/*
 * Decompiled with CFR 0.152.
 */
package panther.util.crypto;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObfuscateDecode {
    public static List<String> decode(String string) throws UnsupportedEncodingException {
        return ObfuscateDecode.separate(ObfuscateDecode.decodeStr(string));
    }

    public static List<String> separate(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < string.length()) {
            int n2;
            int n3 = n;
            if ((n += 4) > string.length()) {
                throw new IndexOutOfBoundsException("premature EOS getting length-prefix");
            }
            String string2 = string.substring(n3, n);
            try {
                n2 = Integer.parseInt(string2, 16);
            }
            catch (NumberFormatException numberFormatException) {
                throw new NumberFormatException("expecting hex length-prefix, got: " + string2);
            }
            n3 = n + n2;
            String string3 = string.substring(n, n3);
            arrayList.add(string3);
            n = n3;
        }
        return arrayList;
    }

    public static String decodeStr(String string) throws UnsupportedEncodingException {
        byte[] byArray = ObfuscateDecode.roughDecode(string, '-', '_');
        ObfuscateDecode.decode(byArray, 0, byArray.length);
        return new String(byArray, "utf-8");
    }

    public static void decode(byte[] byArray, int n, int n2) {
        n2 &= 0xFFFFFFFE;
        while (n < n2) {
            int n3 = n;
            byArray[n3] = (byte)(byArray[n3] ^ 0xA4);
            int n4 = n + 1;
            byArray[n4] = (byte)(byArray[n4] ^ 0x7E);
            int n5 = n;
            byArray[n5] = (byte)(byArray[n5] - 18);
            int n6 = n + 1;
            byArray[n6] = (byte)(byArray[n6] - 73);
            byte by = byArray[n];
            byArray[n] = byArray[n + 1];
            byArray[n + 1] = by;
            n += 2;
        }
    }

    public static byte[] roughDecode(String string, char c, char c2) {
        int n;
        for (n = string.length(); n > 0 && string.charAt(n - 1) == '='; --n) {
        }
        byte[] byArray = new byte[n * 3 / 4];
        int n2 = 0;
        int n3 = 0;
        byte by = 0;
        for (int i = 0; i < n; ++i) {
            int n4;
            char c3 = string.charAt(i);
            if (c3 >= 'A' && c3 <= 'Z') {
                n4 = c3 - 65;
            } else if (c3 >= 'a' && c3 <= 'z') {
                n4 = (byte)(c3 - 97 + 26);
            } else if (c3 >= '0' && c3 <= '9') {
                n4 = (byte)(c3 - 48 + 52);
            } else if (c3 == c) {
                n4 = 62;
            } else if (c3 == c2) {
                n4 = 63;
            } else {
                throw new RuntimeException("Invalid base64(u) char: " + c3);
            }
            if (n3 == 0) {
                by = (byte)(n4 << 2);
                ++n3;
                continue;
            }
            if (n3 == 1) {
                byArray[n2++] = (byte)(by | n4 >> 4 & 3);
                by = (byte)(n4 << 4);
                ++n3;
                continue;
            }
            if (n3 == 2) {
                byArray[n2++] = (byte)(by | n4 >> 2 & 0xF);
                by = (byte)(n4 << 6);
                ++n3;
                continue;
            }
            if (n3 != 3) continue;
            byArray[n2++] = (byte)(by | n4);
            n3 = 0;
        }
        return byArray;
    }
}

